<?php

namespace App\Providers;

use Illuminate\Http\RedirectResponse;
use App\Support\SweetRedirectResponse;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Response;

class MacroServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        if (! Response::hasMacro('api')) {
            Response::macro('api', function (mixed $data, string $message, int $status) {
                return Response::json([
                    'status' => $status,
                    'message' => $message,
                    'data' => $data,
                ], $status);
            });

            Response::macro('success', function (mixed $data = null, ?string $message = null, int $status = 200) {
                return Response::api($data, $message ?? __('api.success'), $status);
            });

            Response::macro('failure', function (mixed $data = null, ?string $message = null, int $status = 500) {
                return Response::api($data, $message ?? __('api.server_error'), $status);
            });
        }


        RedirectResponse::macro('sweetalert', function () {
            return new SweetRedirectResponse($this);
        });
    }
}
