<?php

namespace App\Providers;

use App\Models\Module;
use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Database\Eloquent\Collection;

class ModuleServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton('module', concrete: function ($app): Collection {
            return Module::all()->keyBy('name');
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Blade::if('module', function ($module) {
            return module()->has($module) && module()->get($module)->isActive();
        });
    }
}
