<?php

namespace App\Providers;

use App\PageBuilder\Components\ImageGrid;
use Illuminate\Support\ServiceProvider;

class PageBuilderServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton('page-builder.components', function () {
            return collect([
                ImageGrid::class,
                // ... add more here
            ])->mapWithKeys(fn($class) => [$class::name() => $class]);
        });

        // You can access registered components with:
        // app('page-builder.components')
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}
