<?php

namespace App\Services\Bale;

use App\Data\Bale\UserData;
use App\Models\Product;
use Illuminate\Support\Facades\Http;

class BaleMessengerService
{
    private string $token;

    private string $apiUrl;

    public function __construct()
    {
        $this->token = env('BALE_BOT_TOKEN');

        $this->apiUrl = "https://tapi.bale.ai/bot{$this->token}/";
    }

    public function runTest()
    {
        dd(
            $this->apiUrl,
            UserData::from($this->getMe()['result']),
            $this->getUpdate(),
            // $this->sendMessage('@apg_test', "
            //  *bold text*

            //  __italic text__

            //  [my link](https://alireza-hadizadeh.ir)

            //  ```[متن]‌توضیحات‌```
            // "),

            // $this->forwardMessage(chatId: '6233504542', fromChatId: '6233504542', messageId: '9'),
            // $this->copyMessage(chatId: '6233504542', fromChatId: '6233504542', messageId: '9'),
            // $this->sendPhoto(
            //     chatId: '@apg_test',
            //     fromChatId: '@apg_test',
            //     photo: 'https://wedenta.com/uploads/site_options/SX6Zw1tuqDncrwGSHtwi3XBn7E7NPoQ2ogLZJPxS.webp',
            //     caption: 'salam',
            //     replyToMessageId: 9
            // ),
            // $this->sendPhoto(
            //     chatId: '@apg_test',
            //     fromChatId: '@apg_test',
            //     photo: Product::find(19)->brand_img,
            //     caption: Product::find(19)->content,
            //     replyToMessageId: 9
            // ),


        );
    }

    public  function getUpdate()
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->get($this->apiUrl . 'getUpdates')->json();

        return $response;
    }
    public  function getMe()
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post($this->apiUrl . 'getMe')->json();

        return $response;
    }
    public  function sendMessage(string $chatId, string $text, ?string $replyToMessageId = null, ?string $replyMarkup = null)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post(
            $this->apiUrl . 'sendMessage',
            [
                'chat_id' => $chatId,
                'text' => $text,
                'reply_to_message_id' => $replyToMessageId,
                'reply_markup' => $replyMarkup,
            ]
        )->json();

        return $response;
        // array:2 [▼ // app\Services\Bale\BaleMessengerService.php:23
        // "ok" => true
        // "result" => array:5 [▼
        //      "message_id" => 3
        //      "from" => array:5 [▼
        //          "id" => 860492502
        //          "is_bot" => true
        //          "first_name" => ""
        //          "last_name" => ""
        //          "username" => "alireza_hadizadehbot"
        //     ]
        //          "date" => 1758651119
        //          "chat" => array:2 [▼
        //          "id" => 6233504542
        //          "type" => "group"
        //     ]
        //     "text" => "salam text"
        // ]
        // ]
    }

    /**
     * forwardMessage
     *
     * @param  mixed $chatId شناسه منحصربه‌فرد گفتگوی هدف یا شناسه کانال هدف (با فرمت @channelusername)
     * @param  mixed $fromChatId شناسه منحصربه‌فرد گفتگویی که پیام اصلی در آن‌جا ارسال شده است (یا نام کاربری کانال با فرمت @channelusername)
     * @param  mixed $messageId شناسه پیام در گفتگوی مشخص‌شده در from_chat_id
     */
    public function forwardMessage(string|int $chatId, string|int $fromChatId, int $messageId)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post(
            $this->apiUrl . 'forwardMessage',
            [
                'chat_id' => $chatId,
                'from_chat_id' => $fromChatId,
                'message_id' => $messageId,
            ]
        )->json();

        return $response;
        // array:2 [▼ // app\Services\Bale\BaleMessengerService.php:23
        //     "ok" => true
        //     "result" => array:5 [▼
        //         "message_id" => 11
        //         "from" => array:4 [▼
        //             "id" => 860492502
        //             "is_bot" => true
        //             "first_name" => ""
        //             "last_name" => ""
        //         ]
        //             "date" => 1758699757
        //             "chat" => array:2 [▼
        //             "id" => 6233504542
        //             "type" => "group"
        //         ]
        //         "forward_date" => 1758699757
        //     ]
        // ]
    }
    /**
     * copyMessage
     *
     * @param  mixed $chatId شناسه منحصربه‌فرد گفتگوی هدف یا شناسه کانال هدف (با فرمت @channelusername)
     * @param  mixed $fromChatId شناسه منحصربه‌فرد گفتگویی که پیام اصلی در آن‌جا ارسال شده است (یا نام کاربری کانال با فرمت @channelusername)
     * @param  mixed $messageId شناسه پیام در گفتگوی مشخص‌شده در from_chat_id
     */
    public function copyMessage(string|int $chatId, string|int $fromChatId, int $messageId)
    {
        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
        ])->post(
            $this->apiUrl . 'copyMessage',
            [
                'chat_id' => $chatId,
                'from_chat_id' => $fromChatId,
                'message_id' => $messageId,
            ]
        )->json();

        return $response;
    }

    public function sendPhoto(string|int $chatId, string|int $fromChatId, $photo, ?string $caption = null, ?int $replyToMessageId = null, $replyMarkup = null,)
    {
        $response = null;

        // اگر photo لینک باشه، مستقیم POST می‌کنیم
        if (filter_var($photo, FILTER_VALIDATE_URL)) {
            $response = Http::post($this->apiUrl . 'sendPhoto', [
                'chat_id'             => $chatId,
                'from_chat_id'        => $fromChatId,
                'photo'               => $photo, // لینک
                'caption'             => $caption,
                'reply_to_message_id' => $replyToMessageId,
                'reply_markup'        => $replyMarkup,
            ]);
        } else {
            // اگر مسیر فایل لوکال باشه، با attach ارسال می‌کنیم
            $response = Http::attach(
                'photo',
                file_get_contents($photo),
                basename($photo)
            )->post($this->apiUrl . 'sendPhoto', [
                'chat_id'             => $chatId,
                'from_chat_id'        => $fromChatId,
                'caption'             => $caption,
                'reply_to_message_id' => $replyToMessageId,
                'reply_markup'        => $replyMarkup,
            ]);
        }

        return $response->json();
    }
}
