<?php

namespace App\Services\Models;

use App\Models\Product;
use App\Models\ProductAttribute;
use App\Models\ProductAttributeItem;
use App\Models\ProductAttributeValue;

class ProductAttributeService
{
    /**
     * @param Product $product
     * @param array<int, array{id: int, value: mixed}> $attributes
     */
    public static function createOrUpdateProductAttribute(Product $product, $attributes)
    {
        foreach ($attributes as $attribute) {
            ProductAttributeValue::updateOrCreate(
                [
                    'product_id' => $product->id,
                    'category_attribute_id' => $attribute['id'],
                ],
                [
                    'value' => $attribute['value'],
                ]
            );
        }

        return true;
    }
}
