<?php

namespace App\View\Components\Blesser\Element;

use App\Enums\ProductStatusEnum;
use App\Models\Product;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class ProductOffer extends Component
{
    public $products;
    /**
     * Create a new component instance.
     */
    public function __construct()
    {
        $this->products = Product::where('status', ProductStatusEnum::Published)->where('off_rate', '!=', null)->where('off_rate', '!=', 0)->take(8)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.element.product-offer');
    }
}
