<?php

namespace App\View\Components\Blesser\Element;

use App\Enums\ProductStatusEnum;
use Closure;
use App\Models\Product;
use Illuminate\View\Component;
use Illuminate\Contracts\View\View;

class ProductSlider extends Component
{

    public $title;
    public $link;
    public $category;
    public $products;
    /**
     * Create a new component instance.
     */
    public function __construct($title, $link = '#', $category = null)
    {
        $this->title = $title;
        $this->link = $link;

        $this->products = Product::when($category, function ($query) use ($category) {
            return $query->where('category_id', $category);
        })->where('status', ProductStatusEnum::Published)->take(8)->get();
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.element.product-slider');
    }
}
