<?php

namespace App\View\Components\Blesser\Ui;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class PricingCard extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public string $title,
        public string $price,
        public string $description,
        public array $features = [],
        public string $link = '#',
        public string $buttonText = 'Get Started'
    ) {}

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.blesser.ui.pricing-card');
    }
}
