<?php

use App\Enums\CommentStatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('comments', function (Blueprint $table) {
            $table->id();
            $table->morphs('commentable');
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->string('parent')->nullable()->default(0);
            $table->string('rate');
            $table->boolean('seller_satisfactory')->nullable();
            $table->string('vote_up')->nullable()->default(0);
            $table->string('vote_down')->nullable()->default(0);
            $table->json('good_point')->nullable();
            $table->json('bad_point')->nullable();
            $table->string('status')->nullable()->default(CommentStatusEnum::Pending->value);
            $table->text('content');
            $table->json('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('comments');
    }
};
