<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_times', function (Blueprint $table) {
            $table->id();
            $table->unsignedTinyInteger('day');        // 0 = Sun … 6 = Sat
            $table->time('from');
            $table->time('until');
            $table->unsignedInteger('capacity');       // max deliveries in the slot
            $table->timestamps();

            $table->unique(['day', 'from', 'until']);  // prevent overlaps
        });

        Schema::create('delivery_time_exceptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_time_id')->constrained()->cascadeOnDelete();
            $table->date('date');                      // e.g. 2025-12-25
            $table->timestamps();

            $table->unique(['delivery_time_id', 'date']);
        });

        // (Optional) quick daily look-up cache – huge perf win in high-traffic carts
        Schema::create('delivery_day_capacities', function (Blueprint $table) {
            $table->id();
            $table->date('date');                      // 2025-06-10
            $table->foreignId('delivery_time_id')->constrained()->cascadeOnDelete();
            $table->unsignedInteger('taken')->default(0);
            $table->timestamps();

            $table->unique(['date', 'delivery_time_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_day_capacities');
        Schema::dropIfExists('delivery_time_exceptions');
        Schema::dropIfExists('delivery_times');
    }
};
