<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->morphs('created_by');
            $table->morphs('ordered_by');
            $table->morphs('orderable');

            $table->unsignedBigInteger('address_id')->nullable();
            $table->foreignId('delivery_time_id')->nullable()->constrained();

            $table->string('type');
            $table->string('tracking_code')->unique();
            $table->string('name')->nullable();
            $table->string('phone')->nullable();
            $table->string('email')->nullable();
            $table->decimal('amount', 15, 3)->nullable();
            $table->string('amount_with_discount')->nullable();
            $table->string('discount')->nullable();

            $table->foreignId('coupon_id')->nullable()->constrained(table: 'coupons')->nullOnDelete();
            $table->foreignId('reseller')->nullable()->constrained('users');

            $table->string('status')->nullable()->default(0);
            $table->string('description')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });

        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();

            $table->morphs('item');

            $table->foreignId('inventory_id')->nullable()->constrained('product_inventories')->cascadeOnDelete();
            $table->foreignId('variant_id')->nullable()->constrained('product_inventory_variants')->cascadeOnDelete();
            $table->json('variant')->nullable();

            $table->integer('count');
            $table->string('name');

            $table->decimal('price', 15, 3);
            $table->string('discount')->nullable();
            $table->foreignId('coupon')->nullable()->constrained('coupons');

            $table->json('details')->nullable();

            $table->softDeletes();
            $table->timestamps();
        });

        Schema::create('order_metas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            $table->string('group')->nullable();
            $table->string('key');
            $table->string('value');
            $table->json('data')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
        Schema::dropIfExists('order_metas');
        Schema::dropIfExists('order_items');
    }
};
