<?php

use App\Enums\DeliveryTypeEnum;
use App\Enums\DeliveryStatusEnum;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('deliveries', function (Blueprint $table) {
            $table->id();

            $table->foreignId('order_id')->constrained()->cascadeOnDelete();
            $table->foreignId('delivery_time_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('address_id')->constrained()->cascadeOnDelete();

            $table->string('tracking_code')->unique();
            $table->enum('type', DeliveryTypeEnum::values())->default(DeliveryTypeEnum::Standard->value);
            $table->date('date');                                      // slot date (YYYY-MM-DD)
            $table->time('time')->nullable();                          // optional ETA
            $table->enum('status', DeliveryStatusEnum::values())
                ->default(DeliveryStatusEnum::Pending->value);
            $table->decimal('price', 10, 2)->default(0);

            // optional 3rd-party carrier fields
            $table->string('carrier')->nullable();                     // e.g. DHL, DPD
            $table->string('carrier_code')->nullable();                // carrier’s ID for shipment

            // lat/lon for route optimization
            $table->decimal('origin_lat', 10, 8)->nullable();
            $table->decimal('origin_lon', 11, 8)->nullable();
            $table->decimal('dest_lat', 10, 8)->nullable();
            $table->decimal('dest_lon', 11, 8)->nullable();

            // timestamps
            $table->dateTime('picked_up_at')->nullable();
            $table->dateTime('delivered_at')->nullable();
            $table->timestamps();

            // handy queries
            $table->index(['status', 'date']);
        });

        Schema::create('delivery_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('delivery_id')->constrained()->cascadeOnDelete();
            $table->foreignId('order_item_id')->constrained()->cascadeOnDelete();
            $table->decimal('weight', 10, 2)->nullable();
            $table->string('barcode')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_items');
        Schema::dropIfExists('deliveries');
    }
};
