<?php

use App\Enums\PostStatusEnum;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->foreignId("user_id")->constrained();
            $table->string('author')->nullable();
            $table->string('title')->nullable();
            $table->longText('content')->nullable();
            $table->string('short_desc')->nullable();
            $table->boolean('comment_status')->default(1);
            $table->string('slug')->nullable();
            $table->string('price')->nullable();
            $table->string('password')->nullable();
            $table->string('type')->nullable();
            $table->string('name')->nullable();
            $table->string('layout')->nullable();
            $table->enum('status', PostStatusEnum::values())->nullable()->default(PostStatusEnum::Draft->value);
            $table->string('img')->nullable();
            $table->string('video')->nullable();
            $table->auditable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('posts');
    }
};
