<?php
// 2025_06_05_000004_create_delivery_time_reservations_table.php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('delivery_time_reservations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')
                ->constrained('users')
                ->cascadeOnDelete();
            $table->foreignId('delivery_time_id')
                ->constrained('delivery_times')
                ->cascadeOnDelete();
            $table->date('date');                // Slot date, e.g. 2025-06-10
            $table->dateTime('expires_at');      // e.g. 2025-06-05 14:30:00
            $table->timestamps();

            // Prevent a user from reserving the same slot twice
            $table->unique(
                ['user_id', 'delivery_time_id', 'date'],
                'res_user_time_date_unique'
            );
        });

        // Index for quick lookup of expiring reservations
        Schema::table('delivery_time_reservations', function (Blueprint $table) {
            $table->index('expires_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('delivery_time_reservations');
    }
};
