<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (!Schema::hasColumn('users', 'tier_level')) {
                    $table->string('tier_level')->nullable();
                }
                if (!Schema::hasColumn('users', 'total_points')) {
                    $table->string('total_points')->default('0');
                }
                if (!Schema::hasColumn('users', 'referral_code')) {
                    $table->string('referral_code')->nullable();
                }
            });
        } else {
            Schema::create('users', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('email')->unique();
                $table->string('password');
                $table->string('tier_level')->nullable();
                $table->string('total_points')->default('0');
                $table->string('referral_code')->nullable();
                $table->timestamps();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('users')) {
            Schema::table('users', function (Blueprint $table) {
                if (Schema::hasColumn('users', 'tier_level')) {
                    $table->dropColumn('tier_level');
                }
                if (Schema::hasColumn('users', 'total_points')) {
                    $table->dropColumn('total_points');
                }
                if (Schema::hasColumn('users', 'referral_code')) {
                    $table->dropColumn('referral_code');
                }
            });
        }
    }
};
