<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pre_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pre_invoice_id')->constrained()->cascadeOnDelete();

            // Product information
            $table->foreignId('product_id')->nullable()->constrained('products')->nullOnDelete();
            $table->string('name');
            $table->string('sku')->nullable();

            // Quantity and pricing
            $table->unsignedInteger('qty')->default(1);
            $table->string('unit')->nullable(); // pcs, box, etc.
            $table->unsignedBigInteger('estimated_price')->nullable();

            // Description / external link
            $table->text('description')->nullable();
            $table->string('external_url')->nullable();

            $table->json('options')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pre_invoice_items');
    }
};
