<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quote_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quote_id')->constrained()->cascadeOnDelete();
            $table->foreignId('pre_invoice_item_id')->constrained()->cascadeOnDelete();

            // Supplier’s offer for this item
            $table->unsignedBigInteger('price');
            $table->unsignedInteger('qty')->default(1);
            $table->string('delivery_time')->nullable(); // e.g. "3 days", "2 weeks"
            $table->text('note')->nullable();

            $table->json('options')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quote_items');
    }
};
