<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up(): void
    {
        Schema::create(prefixedTable('flags'), function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->morphs('flaggable');
            $table->text('reason');
            $table->timestamps();
        });
    }
    
    public function down(): void
    {
        Schema::dropIfExists(prefixedTable('flags'));
    }
};
