<?php

namespace Database\Seeders;

use App\Models\Shop;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Database\Seeder;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::create([
            'name' => 'علیرضا هادی زاده',
            'username' => 'alireza',
            'email' => 'alireza.hadizadeh25@yahoo.com',
            'phone' => '09228422123',
            'password' => '$2y$10$6tG2rxGju0DN8qhHV6zsouZuhfCu5RupOMnL4J4tVCwf2Qf0G2hge', // 123456
        ]);
        event(new Registered($user));

        $user->assignRole([
            'Administrator',
            'Admin',
            'Shop',
            'Client',
            'Developer',
        ]);

        $shop = Shop::create(
            [
                'user_id' => $user->id,
                'name' => 'Alireza Shop',
                'slug' => 'alireza-shop',
                'logo' => 'default-logo.png',
                'description' => 'This is the shop of Alireza.',
                'phone' => '09228422123',
                'email' => 'shop@alireza.com',
                'address' => '123 Main Street',
                'city' => 'Tehran',
                'state' => 'Tehran',
                'postal_code' => '1234567890',
                'country' => 'Iran',
                'is_approved' => true,
                'approved_at' => now(),
            ]
        );
    }
}
