<?php

namespace Database\Seeders\Category;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PcCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $categories = [
            [
                "name" => "قطعات اصلی",
                "items" => [
                    "پردازنده (CPU)",
                    "کارت گرافیک (GPU)",
                    "مادربرد",
                    "رم (RAM)",
                    "منبع تغذیه (PSU)",
                    "کیس / شاسی"
                ]
            ],
            [
                "name" => "ذخیره‌سازی",
                "items" => [
                    "هارد دیسک (HDD)",
                    "اس‌اس‌دی (SSD)",
                    "اس‌اس‌دی NVMe",
                    "هارد/اس‌اس‌دی اکسترنال",
                    "هارد هیبریدی (SSHD)",
                    "درایو نوری (DVD / Blu-Ray)"
                ]
            ],
            [
                "name" => "خنک‌کننده و حرارتی",
                "items" => [
                    "خنک‌کننده CPU (هواخنک)",
                    "خنک‌کننده CPU (مایع / AIO)",
                    "فن کیس",
                    "خمیر حرارتی",
                    "کنترلر فن"
                ]
            ],
            [
                "name" => "نمایشگرها",
                "items" => [
                    "مانیتور (LCD/LED)",
                    "مانیتور خمیده",
                    "مانیتور گیمینگ (نرخ تازه‌سازی بالا)",
                    "مانیتور فوق عریض (Ultrawide)",
                    "مانیتور 4K / 8K"
                ]
            ],
            [
                "name" => "ورودی‌ها",
                "items" => [
                    "کیبورد مکانیکی",
                    "کیبورد غشایی",
                    "کیبورد گیمینگ",
                    "موس",
                    "موس گیمینگ",
                    "موس‌پد",
                    "قلم نوری / تبلت گرافیکی"
                ]
            ],
            [
                "name" => "خروجی‌ها",
                "items" => [
                    "اسپیکر",
                    "هدفون",
                    "هدست (گیمینگ / اداری)",
                    "کارت صدا خارجی (DAC)"
                ]
            ],
            [
                "name" => "شبکه",
                "items" => [
                    "کارت شبکه (LAN/NIC)",
                    "آداپتور وای‌فای",
                    "روتر",
                    "سوئیچ شبکه",
                    "مودم",
                    "کابل شبکه"
                ]
            ],
            [
                "name" => "افزودنی‌ها و توسعه",
                "items" => [
                    "کارت صدا داخلی",
                    "کارت کپچر",
                    "کارت‌های توسعه PCIe",
                    "کارت‌های توسعه USB",
                    "کنترلر RAID"
                ]
            ],
            [
                "name" => "کابل‌ها و توان",
                "items" => [
                    "کابل HDMI",
                    "کابل DisplayPort",
                    "کابل DVI / VGA",
                    "کابل USB",
                    "کابل برق",
                    "محافظ برق / UPS"
                ]
            ],
            [
                "name" => "لوازم جانبی",
                "items" => [
                    "وب‌کم",
                    "میکروفون",
                    "هدست واقعیت مجازی (VR)",
                    "داک / استیشن اتصال",
                    "باکس اکسترنال هارد/SSD",
                    "کارت‌خوان",
                    "دسته بازی / جوی‌استیک"
                ]
            ],
            [
                "name" => "نرم‌افزار و سیستم‌عامل",
                "items" => [
                    "سیستم‌عامل (ویندوز، لینوکس، مک)",
                    "نرم‌افزار امنیتی / آنتی‌ویروس",
                    "نرم‌افزارهای کاربردی",
                    "درایورها و ابزارها"
                ]
            ]
        ];

        foreach ($categories as $categoryData) {
            // Create parent category
            $parent = Category::create([
                'name' => $categoryData['name'],
                'parent_id' => 0
            ]);

            // Create subcategories
            foreach ($categoryData['items'] as $index => $itemName) {
                Category::create([
                    'name' => $itemName,
                    'parent_id' => $parent->id,
                    'order_index' => $index + 1
                ]);
            }
        }
    }
}
