<?php

namespace Database\Seeders\Initialization;

use App\Models\Module;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class ModuleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $modules = [
            'multi-shop-seller' => [
                'name' => 'multi-shop-seller',
                'label' => 'Multi Shop / Seller System',
                'is_active' => true,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => true,
            ],

            'loyalty-system' => [
                'name' => 'loyalty-system',
                'label' => 'Artemis Loyalty & Points System',
                'is_active' => true,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => false,
            ],

            'page-builder-grapes-js' => [
                'name' => 'page-builder-grapes-js',
                'label' => 'Visual Page Builder (GrapesJS)',
                'is_active' => true,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => false,
            ],

            'woocommerce-sync' => [
                'name' => 'woocommerce-sync',
                'label' => 'WooCommerce Sync Integration',
                'is_active' => false,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => false,
            ],

            'bale-bot' => [
                'name' => 'bale-bot',
                'label' => 'Bale Bot Integration',
                'is_active' => false,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => false,
            ],
            'pre-invoice' => [
                'name' => 'pre-invoice',
                'label' => 'Pre Invoice',
                'is_active' => false,
                'is_free' => false,
                'is_paid' => true,
                'is_permanent' => false,
            ],
        ];


        foreach ($modules as $key => $module) {
            Module::create($module);
        }
    }
}
