import { makeLaravelBlock } from './block.js';

/**
 * Register Product Slider List block with GrapesJS editor
 * @param {Editor} editor - GrapesJS editor instance
 */
export default function registerProductSliderList(editor) {
    makeLaravelBlock(editor, {
        name: 'product-slider-list',
        label: 'Product Slider List',
        tag: 'x-blesser.element.product-slider-list',
        category: 'Laravel',
        attrs: {
            'data-title': {
                type: 'text',
                default: 'My Products'
            }
        },
        configProps: {
            take: {
                type: 'number',
                default: 15
            },
            category: {
                type: 'text',
                default: 'all'
            }
        }
    });
}
