@props([
'title' => null,
'text' => null,
'url' => null,
])

<button onclick="handleShare()" class="duration-150 cursor-pointer hover:text-primary">
    <div class="i-lucide-share-2 size-6"></div>
</button>
@push('scripts')

<script>
    function getMetaContent(property) {
        const tag = document.querySelector(`meta[property='${property}']`);
        return tag ? tag.content : '';
    }

    function handleShare() {
        const title = @json($title) || getMetaContent('og:title') || document.title;
        const text = @json($text) || getMetaContent('og:description');
        const url = @json($url) || getMetaContent('og:url') || window.location.href;

        if (navigator.share) {
            navigator.share({
                    title,
                    text,
                    url
                })
                .catch(err => console.error('Share failed:', err));
        } else {
            alert('Sharing not supported on this device.');
        }
    }
</script>

@endpush
