@props([
'name',
'placeholder' => __(key: 'message'),
'id' => null,
'type' => 'text',
'label' => '',
'value' => '',
'dir' => 'rtl',
'required' => false,
])

@php
$id = $id ?? $name;
@endphp

<div class="space-y-3">
    <label for="{{ $id }}" class="relative block w-full rounded-lg border bg-muted shadow-sm duration-300 focus-within:border-primary">
        <input
            dir="{{ $dir }}"
            type="{{ $type }}"
            id="{{ $id }}"
            name="{{ $name }}"
            placeholder="{{ $placeholder }}"
            value="{{ old($name, $value) }}"
            {{ $required ? 'required' : '' }}
            {{ $attributes->class(['peer w-full rounded-lg bg-transparent p-3 text-start outline-none focus:ring-0 xs:px-4 xs:py-3']) }}>
        <span class="pointer-events-none absolute start-3 -translate-y-1/2 rounded-full bg-muted px-2 text-xs text-text/80 transition-all duration-200 peer-placeholder-shown:top-1/2 peer-placeholder-shown:text-sm peer-focus:text-xs peer-focus:peer-placeholder-shown:top-0 xs:text-sm md:text-sm md:peer-placeholder-shown:text-base md:peer-focus:text-sm lg:start-5">
            {{ $label }}
        </span>
    </label>
</div>
