@props([
'lat' => 35.6892, // Default to Tehran
'lng' => 51.3890,
'nameLat' => 'latitude',
'nameLng' => 'longitude',
])

<div class="mb-4">
    <label class="block font-semibold mb-1">موقعیت روی نقشه:</label>
    <div id="map" style="height: 400px; border-radius: 8px; overflow: hidden;"></div>
</div>

<input type="hidden" name="{{ $nameLat }}" id="lat-input" value="{{ old($nameLat, $lat) }}">
<input type="hidden" name="{{ $nameLng }}" id="lng-input" value="{{ old($nameLng, $lng) }}">

@once
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
@endonce

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const lat = parseFloat(document.getElementById('lat-input').value) || 35.6892;
        const lng = parseFloat(document.getElementById('lng-input').value) || 51.3890;

        const map = L.map('map').setView([lat, lng], 13);
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; OpenStreetMap contributors'
        }).addTo(map);

        const marker = L.marker([lat, lng], {
            draggable: true
        }).addTo(map);

        marker.on('dragend', function(e) {
            const pos = marker.getLatLng();
            document.getElementById('lat-input').value = pos.lat;
            document.getElementById('lng-input').value = pos.lng;
        });

        map.on('click', function(e) {
            marker.setLatLng(e.latlng);
            document.getElementById('lat-input').value = e.latlng.lat;
            document.getElementById('lng-input').value = e.latlng.lng;
        });

        setTimeout(() => {
            map.invalidateSize();
        }, 200);
    });
</script>
@endpush
