@php
$idPersian = 'persian_' . $name;
$idGregorian = 'gregorian_' . $name;
$format = $timePicker ? 'YYYY/MM/DD HH:mm' : 'YYYY/MM/DD';
@endphp

<div class="mb-3">
    @if($label)
    <label for="{{ $idPersian }}" class="form-label">{{ $label }}</label>
    @endif

    <input type="text" id="{{ $idPersian }}" class="form-control" placeholder="تاریخ {{ $timePicker ? 'و زمان' : 'شمسی' }} را انتخاب کنید" autocomplete="off">
    <input type="text" id="{{ $idGregorian }}" name="{{ $name }}" value="{{ old($name, $value) }}" hidden>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        const options = {
            format: '{{ $format }}',
            autoClose: true,
            initialValue: false,
            calendar: {
                persian: {
                    leapYearMode: 'astronomical'
                }
            },
            onSelect: function(unix) {
                const miladiStr = new persianDate(unix)
                    .toCalendar('gregorian')
                    .toLocale('en')
                    .format('{{ $format === "YYYY/MM/DD HH:mm" ? "YYYY-MM-DD HH:mm" : "YYYY-MM-DD" }}');
                $('#{{ $idGregorian }}').val(miladiStr);
            }
        };

        @if($timePicker)
        options.timePicker = {
            enabled: true,
            showSeconds: false,
            scrollEnabled: true
        };
        @endif

        $('#{{ $idPersian }}').persianDatepicker(options);

        <?php if (old($name, $value)) : ?>
            const parts = '{{ old($name, $value) }}'.split(/[- :]/);
            const pd = new persianDate().toCalendar('gregorian').toLocale('en')
                .year(parts[0]).month(parts[1]).day(parts[2]);

            @if($timePicker)
            pd.hour(parts[3] ?? 0).minute(parts[4] ?? 0);
            @endif

            $('#{{ $idPersian }}').persianDatepicker('setDate', pd.valueOf());
        <?php endif; ?>
    });
</script>
@endpush
