<div>
    @forelse ($items as $item )

    @php
    $hasPermission = empty($item['permission']) || auth()->user()->can($item['permission']);
    $passesCondition = !isset($item['condition']) || (isset($item['condition']) && $item['condition']());
    @endphp

    @if ($hasPermission && $passesCondition)

    @if (isset($item['divider']) && $item['divider'])
    <li class="menu-label">{{ $item['divider'] ?? ''}}</li>
    @endif

    @if (!isset($item['divider']))

    <li>
        <a href="{{ !empty($item['children']) ? 'javascript:;' : ($item['is_url'] ? $item['url'] : route($item['route'] , $item['query'] ?? []))}}" class="{{ !empty($item['children']) ? 'has-arrow' : ''  }}">
            <div class="parent-icon">
                @if (isset($item['icon']) && !empty($item['icon']))
                <i class="{{ $item['icon'] }}"></i>
                @else
                <img src="{{ $item['image'] }}" alt="{{ $item['name'] }}" style="width: 25px; height: 25px; border-radius: 10px; filter: drop-shadow(1px 1px 1px rgba(0, 0, 0, 0.5));">
                @endif

            </div>
            <div class="menu-title">{{ __($item['name']) }}</div>
        </a>
        @if (!empty($item['children']))
        <ul>
            @foreach ($item['children'] as $child)
            @if (empty($child['permission']) || auth()->user()->can($child['permission']))

            <li>
                <a href="{{ $child['is_url'] ? $child['url'] : route($child['route']) }}">{{ $child['name'] }}</a>
            </li>
            @endif
            @endforeach

        </ul>
        @endif
    </li>

    @endif

    @endif

    @empty

    @endforelse
</div>

@push('scripts')

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const labels = document.querySelectorAll('.menu-label');
        labels.forEach(label => {
            let next = label.nextElementSibling;
            let hasItem = false;

            // Check next siblings until another label is found
            while (next && !next.classList.contains('menu-label')) {
                if (next.tagName.toLowerCase() === 'li' && !next.classList.contains('menu-label')) {
                    hasItem = true;
                    break;
                }
                next = next.nextElementSibling;
            }

            // If no item is found, hide the label
            if (!hasItem) {
                label.style.display = 'none';
            }
        });
    });
</script>
@endpush
