@props(['product'])

<div class="">
    <dl class="row">
        <dt class="col-sm-4">{{ __('Category') }}</dt>
        <dd class="col-sm-8">{{ $product->category->name }}</dd>

        <dt class="col-sm-4">{{ __('Title') }}</dt>
        <dd class="col-sm-8">{{ $product->title }}</dd>

        <dt class="col-sm-4">{{ __('Code') }}</dt>
        <dd class="col-sm-8">{{ $product->code }}</dd>

        <dt class="col-sm-4">{{ __('Slug') }}</dt>
        <dd class="col-sm-8">{{ $product->slug }}</dd>

        <dt class="col-sm-4">{{ __('Short Description') }}</dt>
        <dd class="col-sm-8">{{ $product->short_description }}</dd>


        <dt class="col-sm-4">{{ __('Weight') }}</dt>
        <dd class="col-sm-8">{{ $product->weight }}</dd>

        <dt class="col-sm-4">{{ __('Dimensions (L×W×H)') }}</dt>
        <dd class="col-sm-8">{{ $product->length }} × {{ $product->width }} × {{ $product->height }}</dd>

        <dt class="col-sm-4">{{ __('Price') }}</dt>
        <dd class="col-sm-8">{{ $product->price }}</dd>


        <dt class="col-sm-4">{{ __('Brand Image') }}</dt>
        <dd class="col-sm-8">
            @if($product->brand_img)
            <img src="{{$product->brand_img}}" class="img-thumbnail" style="max-height:100px;">
            @else
            {{ __('No image') }}
            @endif
        </dd>

        @forelse ($product->attribute as $attribute )
        <dt class="col-sm-4">{{ $attribute->label}}</dt>
        <dd class="col-sm-8">
            {{ $attribute->value }}
        </dd>
        @empty
        @endforelse
    </dl>
</div>
