@props(['shop'])

<div class="customers-list-item d-flex align-items-center border-bottom p-2 cursor-pointer">
    <div class="">
        <img src="{{ $shop->logo ? asset("uploads/{$shop->logo}"): '/assets/themes/blesser/images/user.png' }}" class="rounded-circle" width="46" height="46" alt="{{ $shop->name ?? 'User' }}">
    </div>
    <div class="ms-2">
        <h6 class="mb-1 font-14">
            {{ $shop->name ?? 'User Name' }}
            @if ($shop->is_approved)
                <span class="badge bg-success">{{ __('Approved') }}</span>
            @else
                <span class="badge bg-warning">{{ __('Pending Approval') }}</span>
            @endif
        </h6>

        <div class="d-flex gap-1">
            <p class="mb-0 font-13 text-secondary">{{ $shop->email ?? __('undefined') }}</p>
            (<p class="mb-0 font-13 text-secondary">{{ $shop->phone ?? __('undefined') }}</p>)

        </div>
    </div>
    <div class="list-inline d-flex customers-contacts ms-auto">
        @can('settings.shops.view')
        <a href="mailto:{{ $shop->email ?? '#' }}" class="list-inline-item"><i class="bx bxs-envelope"></i></a>
        <a href="tel:{{ $shop->phone ?? '#' }}" class="list-inline-item"><i class="bx bxs-phone"></i></a>
        <a href="{{ route('admin.shops.show' , $shop->id) }}" class="list-inline-item"><i class="bx bxs-show"></i></a>
        @endcan
    </div>
</div>
