<div class="suggestion-modern-success-message {{ $class }}">
    <div class="suggestion-icon-wrapper">
        <img src="{{ url('/assets/images/contact-us.svg') }}" alt="">
    </div>
    <div class="suggestion-text-wrapper">
        <div class="title">
            نظرات شما چراغ راه ماست
        </div>
        <div class="suggestion-message">
            از طریق لینک زیر به صورت مستقیم ما با در ارتباط باشید
        </div>
        <div class="suggestion-button-container">
            <a href="{{ route('admin.suggestion.form') }}" class="suggestion-btn suggestion-btn-outline">
                پیشنهادات
            </a>
            <a href="{{ route('admin.suggestion.more-info') }}" class="suggestion-btn suggestion-btn-fill">اطلاعات بیشتر </a>
        </div>
    </div>
</div>


@once
@push('styles')
<style>
    /* From Uiverse.io by kyle1dev */
    .suggestion-modern-success-message {
        display: flex;
        align-items: center;
        padding: 10px 15px;
        /* background: linear-gradient(135deg, #00c6ff, #0072ff); */
        background: linear-gradient(135deg, #0072ff, #2a5298);
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
        color: white;
        position: relative;
        overflow: hidden;
        transition:
            transform 0.3s ease-in-out,
            box-shadow 0.3s ease-in-out;
    }

    .suggestion-modern-success-message:hover {
        transform: scale(1.01);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.25);
    }

    .suggestion-close-btn {
        position: absolute;
        top: 12px;
        left: 20px;
        background: none;
        border: none;
        font-size: 30px;
        color: white;
        cursor: pointer;
        opacity: 0.8;
        transition: opacity 0.3s;
    }

    .suggestion-close-btn:hover {
        opacity: 1;
    }

    .suggestion-icon-wrapper {
        background-color: #0072ff;
        padding: 5px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 20px;
        box-shadow: 0 5px 15px #00c6ff30;
    }

    .suggestion-icon-wrapper img {

        width: 100px;
        aspect-ratio: 1/1;
    }

    .suggestion-success-icon {
        width: 40px;
        height: 40px;
    }

    .suggestion-text-wrapper .title {
        font-size: 18px;
        font-weight: 700;
        letter-spacing: 1.2px;
        text-transform: uppercase;
    }

    .suggestion-text-wrapper .message {
        margin-top: 6px;
        font-size: 14px;
        opacity: 0.85;
    }

    .suggestion-modern-success-message::before {
        content: "";
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        /* background: radial-gradient(circle,
                rgba(255, 255, 255, 0.1),
                rgba(255, 255, 255, 0)); */
        background: radial-gradient(circle,
                rgba(125, 67, 114, 0.1),
                rgba(125, 67, 114, 0));
        transform: rotate(45deg);
        transition: all 0.5s ease-in-out;
    }

    .suggestion-modern-success-message:hover::before {
        transform: rotate(90deg);
        opacity: 0.5;
    }


    /*  woo btns */

    .suggestion-button-container {
        margin-top: 15px;
        display: flex;
        gap: 20px;
    }

    .suggestion-btn {
        padding: 5px 30px;
        font-size: 14px;
        font-weight: 600;
        border-radius: 30px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 1px;
    }



    .suggestion-btn-outline {
        color: white;
        border: 2px solid white;
        background: transparent;
    }

    .suggestion-btn-outline:hover {
        background: white;
        color: #2a5298;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }



    .suggestion-btn-fill {
        background: white;
        color: #2a5298;
        border: 2px solid white;
    }

    html.dark-theme .suggestion-btn-fill {
        background: #2a5298;
    }

    .suggestion-btn-fill:hover {
        background: rgba(255, 255, 255, 0.9);
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
</style>
@endpush
@endonce
