<div class="modern-success-message {{ $class }}">
    <!-- <button class="close-btn">×</button> -->
    <div class="icon-wrapper">
        <!-- <svg
            stroke-linejoin="round"
            stroke-linecap="round"
            stroke-width="2"
            stroke="currentColor"
            fill="none"
            viewBox="0 0 24 24"
            xmlns="http://www.w3.org/2000/svg"
            class="success-icon">
            <path d="M9 12l2 2 4-4"></path>
            <circle r="10" cy="12" cx="12"></circle>
        </svg> -->

        <img src="{{ url('/assets/images/logo-woocommerce.png') }}" alt="">
    </div>
    <div class="text-wrapper">
        <div class="title">آیا فروشگاه ووکامرس دارید ؟</div>
        <div class="message">
            با اتصال فروشگاه ووکامرس خود به راحتی محصولات و سفارشات خودتان را مدیریت کنید
        </div>
        <div class="woo-button-container">
            <a href="{{ route('admin.shop.woocommerce.register') }}" class="woo-btn woo-btn-outline">
                اتصال ووکامرس به فروشگاه
            </a>
            <a href="{{ route('admin.woocommerce.more-info') }}" class="woo-btn woo-btn-fill">اطلاعات بیشتر </a>
        </div>
    </div>
</div>


@once
@push('styles')
<style>
    /* From Uiverse.io by kyle1dev */
    .modern-success-message {
        display: flex;
        align-items: center;
        padding: 10px 15px;
        /* background: linear-gradient(135deg, #00c6ff, #0072ff); */
        background: linear-gradient(135deg, #7a406f, #af2395);
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.15);
        color: white;
        position: relative;
        overflow: hidden;
        transition:
            transform 0.3s ease-in-out,
            box-shadow 0.3s ease-in-out;
    }

    .modern-success-message:hover {
        transform: scale(1.01);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.25);
    }

    .close-btn {
        position: absolute;
        top: 12px;
        left: 20px;
        background: none;
        border: none;
        font-size: 30px;
        color: white;
        cursor: pointer;
        opacity: 0.8;
        transition: opacity 0.3s;
    }

    .close-btn:hover {
        opacity: 1;
    }

    .icon-wrapper {
        /* background-color: rgba(255, 255, 255, 0.15); */
        background-color: rgba(125, 67, 114, 1);
        padding: 5px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: 20px;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .icon-wrapper img {
        width: 100px;
    }

    .success-icon {
        width: 40px;
        height: 40px;
    }

    .text-wrapper .title {
        font-size: 18px;
        font-weight: 700;
        letter-spacing: 1.2px;
        text-transform: uppercase;
    }

    .text-wrapper .message {
        margin-top: 6px;
        font-size: 14px;
        opacity: 0.85;
    }

    .modern-success-message::before {
        content: "";
        position: absolute;
        top: -50%;
        left: -50%;
        width: 200%;
        height: 200%;
        /* background: radial-gradient(circle,
                rgba(255, 255, 255, 0.1),
                rgba(255, 255, 255, 0)); */
        background: radial-gradient(circle,
                rgba(125, 67, 114, 0.1),
                rgba(125, 67, 114, 0));
        transform: rotate(45deg);
        transition: all 0.5s ease-in-out;
    }

    .modern-success-message:hover::before {
        transform: rotate(90deg);
        opacity: 0.5;
    }


    /*  woo btns */

    .woo-button-container {
        margin-top: 15px;
        display: flex;
        gap: 20px;
    }

    .woo-btn {
        padding: 5px 30px;
        font-size: 14px;
        font-weight: 600;
        border-radius: 30px;
        cursor: pointer;
        transition: all 0.3s ease;
        text-transform: uppercase;
        letter-spacing: 1px;
    }

    .woo-btn-outline {
        color: white;
        border: 2px solid white;
        background: transparent;
    }

    .woo-btn-outline:hover {
        background: white;
        color: #af2395;
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }

    .woo-btn-fill {
        background: white;
        color: #7a406f;
        border: 2px solid white;
    }

    html.dark-theme .woo-btn-fill{
        background: #7a406f;
    }

    .woo-btn-fill:hover {
        background: rgba(255, 255, 255, 0.9);
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    }
</style>
@endpush
@endonce
