@props(['attribute' => null , 'category' => null])
<div x-data="{expertOption:false}">
    @if ($errors->any())
    <x-syndron.ui.alert type="danger" title="{{ __('error') }}" icon="bx bxs-message-square-x">
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </x-syndron.ui.alert>
    @endif

    <form method="POST" action="{{ $attribute ? route('admin.category.attribute.update', [$category->id, $attribute->id]) : route('admin.category.attribute.store', $category->id) }}">
        @csrf
        @if($attribute)
        @method('PUT')
        @endif


        <div class="mb-3">
            <label for="label" class="form-label">{{ __('Label') }}</label>
            <input type="text" name="label" class="form-control @error('label') is-invalid @enderror"
                value="{{ old('label', $attribute?->label) }}" placeholder="{{ __('Enter label') }}">
            @error('label') <div class="invalid-feedback">{{ $message }}</div> @enderror
        </div>

        <div class="mb-3">
            <label for="type" class="form-label">{{ __('Type') }}</label>
            <select name="type" class="form-select @error('type') is-invalid @enderror">
                <option value="">{{ __('chose') }}</option>
                @foreach (\App\Enums\CategoryAttributeTypeEnum::values() as $type )
                <option value="{{ $type }}" {{ old('type', $attribute?->type) == $type ? 'selected' : '' }}>
                    {{ __($type) }}
                </option>
                @endforeach
            </select>

            @error('type') <div class="invalid-feedback">{{ $message }}</div> @enderror
        </div>

        <div class="form-check mb-3">
            <input @click="expertOption = !expertOption" class="form-check-input" type="checkbox" name="expert_felid" id="expert_felid" value="true"
                {{ old('expert_felid', $attribute?->expert_felid) ? 'checked' : '' }}>
            <label class="form-check-label" for="expert_felid">
                {{ __('Advanced fields') }}
            </label>
        </div>

        <div x-show="expertOption">
            <div class="mb-3">
                <label for="name" class="form-label">{{ __('Name') }}</label>
                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror"
                    value="{{ old('name', $attribute?->name) }}" placeholder="{{ __('Enter attribute name') }}">
                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
                <label for="default_value" class="form-label">{{ __('Default Value') }}</label>
                <input type="text" name="default_value" class="form-control @error('default_value') is-invalid @enderror"
                    value="{{ old('default_value', $attribute?->default_value) }}" placeholder="{{ __('Enter default value') }}">
                @error('default_value') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="is_required" id="is_required" value="true"
                    {{ old('is_required', $attribute?->is_required) ? 'checked' : '' }}>
                <label class="form-check-label" for="is_required">
                    {{ __('Is Required') }}
                </label>
                @error('is_required') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="is_filterable" id="is_filterable" value="true"
                    {{ old('is_filterable', $attribute?->is_filterable) ? 'checked' : '' }}>
                <label class="form-check-label" for="is_filterable">
                    {{ __('Is Filterable') }}
                </label>
                @error('is_filterable') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
                <label for="filter_type" class="form-label">{{ __('Filter Type') }}</label>

                <select name="filter_type" class="form-select @error('filter_type') is-invalid @enderror">
                    <option value="">{{ __('chose') }}</option>
                    @foreach (\App\Enums\CategoryAttributeTypeEnum::values() as $type )
                    <option value="{{ $type }}" {{ old('filter_type', $attribute?->filter_type) == $type ? 'selected' : '' }}>
                        {{ __($type) }}
                    </option>
                    @endforeach
                </select>
                @error('filter_type') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="form-check mb-3">
                <input class="form-check-input" type="checkbox" name="is_price_effective" id="is_price_effective" value="true"
                    {{ old('is_price_effective', $attribute?->is_price_effective ?? $_GET['is_variant'] ?? '') ? 'checked' : '' }}>
                <label class="form-check-label" for="is_price_effective">
                    {{ __('Is Price Effective') }}
                </label>
                @error('is_price_effective') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>

            <div class="mb-3">
                <label for="validation" class="form-label">{{ __('Validation Rules') }}</label>
                <input type="text" name="validation" class="form-control @error('validation') is-invalid @enderror"
                    value="{{ old('validation', $attribute?->validation) }}" placeholder="{{ __('Enter validation rules') }}">
                @error('validation') <div class="invalid-feedback">{{ $message }}</div> @enderror
            </div>
        </div>

        <button type="submit" class="btn btn-primary">{{ $attribute ? __('Update') : __('Create') }}</button>
    </form>
</div>
