@props(['item' => null ,'attribute' => null])

@php
$isEdit = isset($item) && $item->exists;
@endphp
<form x-data="{expertOption:false}" class="" action="{{ $isEdit ? route('admin.attribute.item.update', ['attribute' => $attribute->id , 'item' => $item->id]) : route('admin.attribute.item.store' ,$attribute->id) }}" method="POST" enctype="multipart/form-data">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="col-sm-12 mb-3">
        <label for="item_value" class="form-label">{{ __('name of the item') }}</label>
        <input type="text" name="item_value" id="item_value" class="form-control">
    </div>

    <div class="form-check mb-3">
        <input @click="expertOption = !expertOption" class="form-check-input" type="checkbox" name="expert_felid" id="expert_felid" value="true"
            {{ old('expert_felid', $attribute?->expert_felid) ? 'checked' : '' }}>
        <label class="form-check-label" for="expert_felid">
            {{ __('Advanced fields') }}
        </label>
    </div>

    <div class="col-sm-12 mb-3" x-show="expertOption">
        <label for="item_key" class="form-label">{{ __('name of the item in English') }}</label>
        <input type="text" name="item_key" id="item_key" class="form-control">
        <small>
            {{ __('Please enter a valid name. The name should follow these rules:')}} <br />
            - {{ __('It should be in English.')}} <br />
            - {{ __('It cannot contain spaces.')}} <br />
            - {{ __('It cannot start with a number.')}} <br />
            - {{ __('It should only contain alphanumeric characters and underscores.')}} <br />
            - {{ __('It should be unique within the context.')}} <br />
        </small>
    </div>

    <div class="col-sm-12 mb3 d-flex justify-content-end">
        <button type="submit" class="btn btn-primary px-5">
            {{ __('submit') }}
        </button>

    </div>
</form>
