@props(['coupon' => null, 'productsList' => [], 'categoriesList' => []])

@php
$isEdit = isset($coupon) && $coupon->exists;
$couponTypes = \App\Models\Coupon::TYPES;
@endphp

<form class="" action="{{ $isEdit ? route('admin.coupons.update', $coupon) : route('admin.coupons.store') }}" method="POST">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="row">
        {{-- General Information --}}
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">
                    {{ __('General Information') }}
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label" for="code">{{ __('Coupon Code') }} <span class="text-danger">*</span></label>
                        <input type="text" name="code" id="code" value="{{ old('code', $coupon->code ?? '') }}" class="form-control @error('code') is-invalid @enderror" required>
                        @error('code')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="description">{{ __('Description') }}</label>
                        <textarea name="description" id="description" class="form-control @error('description') is-invalid @enderror" rows="3">{{ old('description', $coupon->description ?? '') }}</textarea>
                        @error('description')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="type">{{ __('Discount Type') }} <span class="text-danger">*</span></label>
                        <select name="type" id="type" class="form-select @error('type') is-invalid @enderror" required>
                            @foreach($couponTypes as $type)
                            <option value="{{ $type }}" {{ old('type', $coupon->type ?? '') == $type ? 'selected' : '' }}>{{ $type }}</option>
                            @endforeach
                        </select>
                        @error('type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="amount">{{ __('Coupon Amount') }} <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" name="amount" id="amount" value="{{ old('amount', $coupon->amount ?? '') }}" class="form-control @error('amount') is-invalid @enderror" required>
                        @error('amount')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <x-form.persian-datepicker name="expire_date" label="تاریخ انقضا" :value="$coupon?->expire_date" :timePicker="true" />

                        @error('expire_date')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="allow_free_shipment" id="allow_free_shipment" value="1" {{ old('allow_free_shipment', $coupon->allow_free_shipment ?? false) ? 'checked' : '' }}>
                        <label class="form-check-label" for="allow_free_shipment">
                            {{ __('Allow Free Shipment') }}
                        </label>
                    </div>
                </div>
            </div>
        </div>

        {{-- Usage Restriction --}}
        <div class="col-md-6">
            <div class="card mb-3">
                <div class="card-header">
                    {{ __('Usage Restriction') }}
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label" for="minimum_spend">{{ __('Minimum Spend') }}</label>
                        <input type="number" step="0.01" name="minimum_spend" id="minimum_spend" value="{{ old('minimum_spend', $coupon->minimum_spend ?? '') }}" class="form-control @error('minimum_spend') is-invalid @enderror">
                        @error('minimum_spend')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="maximum_spend">{{ __('Maximum Spend') }}</label>
                        <input type="number" step="0.01" name="maximum_spend" id="maximum_spend" value="{{ old('maximum_spend', $coupon->maximum_spend ?? '') }}" class="form-control @error('maximum_spend') is-invalid @enderror">
                        @error('maximum_spend')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="max_discount">{{ __('Maximum Discount (for percentage type)') }}</label>
                        <input type="number" step="0.01" name="max_discount" id="max_discount" value="{{ old('max_discount', $coupon->max_discount ?? '') }}" class="form-control @error('max_discount') is-invalid @enderror">
                        @error('max_discount')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="individual_use_only" id="individual_use_only" value="1" {{ old('individual_use_only', $coupon->individual_use_only ?? false) ? 'checked' : '' }}>
                        <label class="form-check-label" for="individual_use_only">
                            {{ __('Individual Use Only') }}
                        </label>
                    </div>

                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="exclude_sale_items" id="exclude_sale_items" value="1" {{ old('exclude_sale_items', $coupon->exclude_sale_items ?? false) ? 'checked' : '' }}>
                        <label class="form-check-label" for="exclude_sale_items">
                            {{ __('Exclude Sale Items') }}
                        </label>
                    </div>

                    {{-- For simplicity, using textareas for JSON fields. Consider using select2 or similar for better UX --}}
                    <div class="mb-3">
                        <label class="form-label" for="products">{{ __('Products (comma-separated IDs)') }}</label>
                        <textarea name="products_text" id="products" class="form-control @error('products') is-invalid @enderror" rows="2">{{ old('products_text', $coupon && is_array($coupon->products) ? implode(',', $coupon->products) : '') }}</textarea>
                        @error('products') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="exclude_products">{{ __('Exclude Products (comma-separated IDs)') }}</label>
                        <textarea name="exclude_products_text" id="exclude_products" class="form-control @error('exclude_products') is-invalid @enderror" rows="2">{{ old('exclude_products_text', $coupon && is_array($coupon->exclude_products) ? implode(',', $coupon->exclude_products) : '') }}</textarea>
                        @error('exclude_products') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="product_categories">{{ __('Product Categories (comma-separated IDs)') }}</label>
                        <textarea name="product_categories_text" id="product_categories" class="form-control @error('product_categories') is-invalid @enderror" rows="2">{{ old('product_categories_text', $coupon && is_array($coupon->product_categories) ? implode(',', $coupon->product_categories) : '') }}</textarea>
                        @error('product_categories') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="exclude_categories">{{ __('Exclude Categories (comma-separated IDs)') }}</label>
                        <textarea name="exclude_categories_text" id="exclude_categories" class="form-control @error('exclude_categories') is-invalid @enderror" rows="2">{{ old('exclude_categories_text', $coupon && is_array($coupon->exclude_categories) ? implode(',', $coupon->exclude_categories) : '') }}</textarea>
                        @error('exclude_categories') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label" for="allowed_emails">{{ __('Allowed Emails (comma-separated)') }}</label>
                        <textarea name="allowed_emails_text" id="allowed_emails" class="form-control @error('allowed_emails') is-invalid @enderror" rows="2">{{ old('allowed_emails_text', $coupon && is_array($coupon->allowed_emails) ? implode(',', $coupon->allowed_emails) : '') }}</textarea>
                        @error('allowed_emails') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        {{-- Usage Limits --}}
        <div class="col-md-12">
            <div class="card mb-3">
                <div class="card-header">
                    {{ __('Usage Limits') }}
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <label class="form-label" for="usage_limit">{{ __('Usage Limit Per Coupon') }}</label>
                            <input type="number" name="usage_limit" id="usage_limit" value="{{ old('usage_limit', $coupon->usage_limit ?? '') }}" class="form-control @error('usage_limit') is-invalid @enderror">
                            @error('usage_limit')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label" for="product_limit">{{ __('Limit Usage To X Items') }}</label>
                            <input type="number" name="product_limit" id="product_limit" value="{{ old('product_limit', $coupon->product_limit ?? '') }}" class="form-control @error('product_limit') is-invalid @enderror">
                            @error('product_limit')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-4 mb-3">
                            <label class="form-label" for="usage_limit_per_user">{{ __('Usage Limit Per User') }}</label>
                            <input type="number" name="usage_limit_per_user" id="usage_limit_per_user" value="{{ old('usage_limit_per_user', $coupon->usage_limit_per_user ?? '') }}" class="form-control @error('usage_limit_per_user') is-invalid @enderror">
                            @error('usage_limit_per_user')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? __('Update Coupon') : __('Create Coupon') }}</button>
    <a href="{{ route('admin.coupons.index') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
</form>
