@props(['question' => null, 'statuses'])

@php
$isEdit = isset($question) && $question->exists;
@endphp

<form class="" action="{{ $isEdit ? route('admin.faq.questions.update', $question) : route('admin.faq.questions.store') }}" method="POST">
    @csrf
    @if($isEdit)
    @method('PUT')
    @endif

    <div class="mb-3">
        <label class="form-label">{{ __('Title') }}</label>
        <input type="text" name="title" value="{{ old('title', $question->title ?? '') }}" class="form-control @error('title') is-invalid @enderror">
        @error('title')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Slug') }}</label>
        <input type="text" name="slug" value="{{ old('slug', $question->slug ?? '') }}" class="form-control @error('slug') is-invalid @enderror">
        @error('slug')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Body') }}</label>
        <textarea name="body" class="form-control @error('body') is-invalid @enderror">{{ old('body', $question->body ?? '') }}</textarea>
        @error('body')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Category') }}</label>
        <select name="category_id" class="form-select @error('category_id') is-invalid @enderror">
            @foreach(\Artemis\Faq\Models\Category::all() as $category)
            <option value="{{ $category->id }}" {{ old('category_id', $question->category_id ?? '') == $category->id ? 'selected' : '' }}>
                {{ $category->name }}
            </option>
            @endforeach
        </select>
        @error('category_id')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('Status') }}</label>
        <select name="status" class="form-select @error('status') is-invalid @enderror">
            @foreach($statuses as $status)
            <option value="{{ $status->value }}" {{ old('status', $question->status ?? '') == $status->value ? 'selected' : '' }}>
                {{ $status->name }}
            </option>
            @endforeach
        </select>
        @error('status')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <div class="mb-3">
        <label class="form-label">{{ __('User') }}</label>
        <select name="user_id" class="form-select @error('user_id') is-invalid @enderror">
            @foreach(\App\Models\User::all() as $user)
            <option value="{{ $user->id }}" {{ old('user_id', $question->user_id ?? '') == $user->id ? 'selected' : '' }}>
                {{ $user->name }}
            </option>
            @endforeach
        </select>
        @error('user_id')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>

    <button type="submit" class="btn btn-primary">{{ $isEdit ? __('Update') : __('Create') }} {{ __('Question') }}</button>
</form>
