@props(['category' , 'is_price_effective' => 0 , 'item_value' => 1 ,'product'=> null])
<div id="product-type-attributes-container" class="mb-3">
    <div class="border border-3 p-4 rounded ">
        <p>
            {{ __('Product Attribute ') }}
        </p>
        <div class="row">
            @php
            $productAttributes = $product?->attribute->keyBy('category_attribute_id');
            @endphp
            @forelse ( \App\Services\Models\CategoryAttributeService::getCategoryAttributes($category,true)->where('is_price_effective' , $is_price_effective)->get() as $attribute )


            <input type="text" name="attributes[{{$attribute->name}}][id]" value="{{$attribute->id}}" hidden>

            <div class="col-sm-12 mb-3">
                <label class="form-label" for="attribute_{{$attribute->name}}">{{ $attribute->label }}</label>

                @if ($attribute->type == 'text')
                <input class="form-control" type="text" name="attributes[{{$attribute->name}}][value]" id="attribute_{{$attribute->name}}" value="<?= old('attribute_' . $attribute->name) ?? $productAttributes[$attribute->id]->value ?? $attribute->default_value ?>">
                @endif
                @if ($attribute->type == 'integer')
                <input class="form-control" type="number" name="attributes[{{$attribute->name}}][value]" id="attribute_{{$attribute->name}}" value="<?= old('attribute_' . $attribute->name) ?? $productAttributes[$attribute->id]->value ?? $attribute->default_value ?>">
                @endif
                @if ($attribute->type == 'select')

                @php
                $inputs = $attribute->items->map(function ($item) {
                return ['value' => $item->id, 'label' => $item->item_value, 'name' => $item->item_group];
                });
                @endphp
                <x-syndron.ui.form.input-radio-inline-row name="attributes[{{$attribute->name}}][value]" :inputs="$inputs" />
                @endif
            </div>

            @empty

            @endforelse

        </div>
    </div>
</div>
