@props(['product' => null])

<!-- product title and details -->
<div class="border border-3 p-4 rounded mb-3">
    <div id="product-title-container" class="mb-3">
        <label for="title" class="form-label"> {{ __('title') }} <span class="text-danger">*</span> </label>
        <input type="text" class="form-control" name="title" id="title" placeholder="{{ __('Name of the product') }}" value="{{ old('title' , $product?->title) }}">
    </div>
    <div id="product-content-container" class="mb-3">
        <label for="content" class="form-label">{{ __('content') }}</label>
        <x-form.quill-editor name="content" :value="old('content', $product?->content ?? '')" />

    </div>
</div>
