@props([ 'tag' => null])

@php
$isEdit = isset($tag) && $tag->exists;
@endphp

<form action="{{ $isEdit ? route('admin.tags.update' , $tag->id ) : route('admin.tags.store') }}" method="POST">
    @csrf

    @if($isEdit)
    @method('PATCH')
    @endif

    <div class="mb-3">
        <label for="name" class="form-label">{{ __('tag Name') }}</label>
        <input type="text" name="name" class="form-control" value="{{ old('name', $tag->name ?? '') }}" required>
    </div>
    <div class="mb-3">
        <label class="form-label">{{ __('Slug') }} <span class="text-danger">(*)</span></label>
        <input type="text" name="slug" value="{{ old('slug', $tag->slug ?? '') }}" class="form-control @error('slug') is-invalid @enderror">
        @error('slug')
        <div class="invalid-feedback">{{ $message }}</div>
        @enderror
    </div>
    <div class="mb-3">
        <label for="color" class="form-label">{{ __('color') }}</label>
        <input type="text" name="color" class="form-control" value="{{ old('color', $tag->color ?? '') }}" required>
    </div>
    <div class="mb-3">
        <label for="description" class="form-label">{{ __('description') }}</label>
        <input type="text" name="description" class="form-control" value="{{ old('description', $tag->description ?? '') }}" required>
    </div>



    <button type="submit" class="btn btn-primary">{{ __('Save') }}</button>
</form>
