@props(['old' => null ])
<div class="border border-3 p-4 rounded mb-3 ">
    @if ($label)
    <label class="form-label">{{ __($label) }} {!! $old == null ? '<span class="text-danger">*</span>' : '' !!}</label>
    @endif

    <input type="file"
        accept="image/*"
        name="<?php echo $name ?>"
        id="<?php echo $name ?>_input"
        class="form-control"
        onchange="previewImage_<?php echo $name ?>(event)">

    <div class="mt-2">
        <img id="<?php echo $name ?>_preview"
            src="{{ $old ?? '#' }}"
            style="max-width: 200px; <?php echo $old == null ? 'display: none;' : '' ?>"
            class="img-thumbnail" />
    </div>

</div>

@push('scripts')
<script>
    function previewImage_<?php echo $name ?>(event) {
        const [file] = event.target.files;
        const preview = document.getElementById('<?php echo $name ?>_preview');
        if (file && file.type.startsWith('image/')) {
            preview.src = URL.createObjectURL(file);
            preview.style.display = 'block';
        } else {
            preview.style.display = 'none';
        }
    }
</script>
@endpush
