{{-- resources/views/components/grid-menu.blade.php --}}
@props(['items'])

@once
@push('styles')
<style>
    :root {
        --gm-grid-gap: 1.5rem;
        --gm-item-radius: 0.75rem;
        --gm-transition-speed: 0.3s;
    }

    /* container */
    .gm-grid-menu {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: var(--gm-grid-gap);
        margin: 0 auto;
        max-width: 72rem;
        /* ~6xl */
        padding: 1.5rem;
    }

    @media (min-width: 640px) {
        .gm-grid-menu {
            grid-template-columns: repeat(3, 1fr);
        }
    }

    @media (min-width: 768px) {
        .gm-grid-menu {
            grid-template-columns: repeat(4, 1fr);
        }
    }

    @media (min-width: 1024px) {
        .gm-grid-menu {
            grid-template-columns: repeat(5, 1fr);
        }
    }

    @media (max-width: 640px) {
        :root {
            --gm-grid-gap: 1rem;
        }
    }

    /* items */
    .gm-menu-item {
        position: relative;
        overflow: hidden;
        background: #fff;
        border: 1px solid #f3f4f6;
        border-radius: var(--gm-item-radius);
        padding: 1.5rem;
        text-align: center;
        transition: all var(--gm-transition-speed) ease;
        transform: translateY(0);
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        text-decoration: none;
        color: inherit;
    }

    .gm-menu-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
    }

    .gm-menu-item::before {
        content: "";
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0) 50%);
        opacity: 0;
        transition: opacity var(--gm-transition-speed) ease;
    }

    .gm-menu-item:hover::before {
        opacity: 1;
    }

    /* icon */
    .gm-menu-icon {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        background: #bfdbfe;
        padding: 1rem;
        border-radius: 50%;
        margin-bottom: 1rem;
        font-size: 2rem;
        color: #1e40af;
        transition: transform var(--gm-transition-speed) ease;
    }

    .gm-menu-item:hover .gm-menu-icon {
        transform: scale(1.1);
    }

    /* text */
    .gm-menu-title {
        margin: 0 0 0.25rem;
        font-size: 1.125rem;
        font-weight: 600;
        color: #1f2937;
    }

    .gm-menu-description {
        margin: 0;
        font-size: 0.875rem;
        color: #6b7280;
    }

    /* badge */
    .gm-menu-badge {
        position: absolute;
        top: 0.5rem;
        right: 0.5rem;
        background: #ef4444;
        color: #fff;
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
        border-radius: 9999px;
        line-height: 1;
    }
</style>
@endpush
@endonce

<div class="gm-grid-menu">
    @foreach ($items as $item)
    <a href="{{ $item['url'] }}" class="gm-menu-item">
        <div class="gm-menu-icon">
            {!! $item['icon'] !!}
        </div>
        <h3 class="gm-menu-title">{{ $item['title'] }}</h3>
        <p class="gm-menu-description">{{ $item['description'] }}</p>
        @if (!empty($item['badge']))
        <span class="gm-menu-badge">{{ $item['badge'] }}</span>
        @endif
    </a>
    @endforeach
</div>
