<!DOCTYPE html>
<html lang="fa-IR" dir="rtl">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <link rel="stylesheet" href="/assets/themes/blesser/css/fonts.css" />

    <link rel="stylesheet" href="/assets/themes/blesser/css/app.css" />

    <link rel="stylesheet" href="/assets/themes/blesser/css/base.css" />

    <script defer src="/assets/themes/blesser/scripts/theme.js"></script>
    <script src="/assets/themes/blesser/scripts/mount.js"></script>

    <style>
        .loader {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            display: block;
            margin: 15px auto;
            position: relative;
            color: #FFF;
            box-sizing: border-box;
            animation: animloader 2s linear infinite;
        }

        @keyframes animloader {
            0% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }

            25% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 2px;
            }

            50% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 -2px, -14px 0 0 2px, -38px 0 0 -2px;
            }

            75% {
                box-shadow: 14px 0 0 2px, 38px 0 0 -2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }

            100% {
                box-shadow: 14px 0 0 -2px, 38px 0 0 2px, -14px 0 0 -2px, -38px 0 0 -2px;
            }
        }
    </style>
    <title>ورود / ثبت نام</title>
</head>

<body>
    <div class="bg-dot-rgba(1,1,1,0.1) dark:bg-dot-rgba(254,254,255,0.1) relative flex min-h-screen w-full items-center justify-center overflow-x-hidden bg-background">
        <div class="pointer-events-none absolute inset-0 flex items-center justify-center bg-background [mask-image:radial-gradient(ellipse_at_center,transparent_80%,black)] lg:[mask-image:radial-gradient(ellipse_at_center,transparent_20%,black)]"></div>
        <!-- background -->
        <div class="pointer-events-none absolute inset-0 flex w-screen items-center justify-center overflow-hidden [mask-image:radial-gradient(transparent_15%,white)]">
            <svg class="absolute left-0 top-0 h-full w-full stroke-black/10 stroke-[2] [mask-image:linear-gradient(transparent_15%,white,transparent_85%)] dark:stroke-white/10" data-n-ids='{"1a4MN34vH0:0":"1a4MN34vH0:0"}'>
                <rect width="100%" height="100%" stroke-width="0" fill="url(#grid-pattern-1a4MN34vH0:0)"></rect>
                <svg>
                    <rect stroke-width="0" width="95" height="95" x="97" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="385" y="193" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="193" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="673" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="481" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1249" y="97" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="577" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1441" y="385" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1057" y="289" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="961" y="481" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                    <rect stroke-width="0" width="95" height="95" x="1249" y="577" class="pointer-events-auto fill-black/5 transition duration-500 hover:fill-black/10 dark:fill-white/5 dark:hover:fill-white/10"></rect>
                </svg>
                <defs>
                    <pattern id="grid-pattern-1a4MN34vH0:0" viewBox="0 0 64 64" width="96" height="96" patternUnits="userSpaceOnUse">
                        <path d="M64 0H0V64" fill="none"></path>
                    </pattern>
                </defs>
            </svg>

            <svg width="1512" height="1714" viewBox="0 0 1512 1714" fill="none" xmlns="http://www.w3.org/2000/svg" class="pointer-events-none absolute left-0 top-0 h-auto w-full lg:w-1/2">
                <g clip-path="url(#clip0_143_13)">
                    <g filter="url(#filter0_f_143_13)">
                        <path d="M1045.18 982.551C1129.83 903.957 204.996 477.237 -235.529 294L-339.645 584.211C59.2367 752.376 960.521 1061.15 1045.18 982.551Z" fill="white" fill-opacity="0.15"></path>
                    </g>
                </g>
                <defs>
                    <filter id="filter0_f_143_13" x="-595.645" y="38" width="1902.26" height="1213.13" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                        <feBlend mode="normal" in="SourceGraphic" in2="BackgroundImageFix" result="shape"></feBlend>
                        <feGaussianBlur stdDeviation="64" result="effect1_foregroundBlur_143_13"></feGaussianBlur>
                    </filter>
                    <clipPath id="clip0_143_13">
                        <rect width="1512" height="1714" fill="white"></rect>
                    </clipPath>
                </defs>
            </svg>
        </div>
        <div class="absolute left-2 top-2">
            <button onclick="toggleDark(event)" class="icon-btn h-10 w-10">
                <i class="i-carbon-moon !h-6 !w-6 dark:i-carbon-sun"></i>
            </button>
        </div>

        @yield('content')
    </div>
    @yield('script')
    @stack('scripts')

</body>


</html>