<div>
    @if ($show)
    <div class="modal fade show d-block" tabindex="-1" style="background: rgba(0,0,0,0.5)">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Select or Upload Image</h5>
                    <button type="button" wire:click="$set('show', false)" class="btn-close"></button>
                </div>
                <div class="modal-body">
                    <ul class="nav nav-tabs" id="pickerTabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#uploadTab">Upload</button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#libraryTab">Library</button>
                        </li>
                    </ul>

                    <div class="tab-content mt-3">
                        <div class="tab-pane fade show active" id="uploadTab">
                            <input type="file" wire:model="uploadedFile" class="form-control">
                            @if ($uploadedFile)
                            <img src="{{ $uploadedFile->temporaryUrl() }}" class="img-fluid mt-2" style="max-height:150px;">
                            <button class="btn btn-primary mt-2" wire:click="uploadFile">Use this file</button>
                            @endif
                        </div>

                        <div class="tab-pane fade" id="libraryTab">
                            <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-2">
                                @foreach ($files as $file)
                                <div class="col">
                                    <img src="{{ $file }}" class="img-thumbnail cursor-pointer"
                                        style="height: 120px; object-fit: cover;"
                                        wire:click="selectFile('{{ $file }}')">
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>
