<div class="container py-4">
    <h2 class="h4 fw-bold mb-4">Editing Page: {{ $page->title }}</h2>

    {{-- Component Selector Grid --}}
    <div class="mb-4">
        <h5 class="fw-bold">Add Component to Page</h5>
        <div class="row row-cols-2 row-cols-sm-3 row-cols-md-4 g-3">
            @foreach ($components as $name => $class)
            <div class="col">
                <button wire:click="addComponent('{{ $name }}')" type="button" class="btn btn-outline-primary w-100 py-3">
                    <div class="fs-4">📦</div>
                    <div class="small fw-semibold mt-1">{{ $class::label() }}</div>
                </button>
            </div>
            @endforeach
        </div>
    </div>

    {{-- Component Items --}}
    @foreach ($items as $index => $item)
    @php
    $componentClass = $components[$item['component']] ?? null;
    $fields = $componentClass ? $componentClass::fields() : [];
    @endphp

    <div class="card mb-4" wire:key="item-{{ $index }}">
        <div class="card-header d-flex justify-content-between align-items-center">
            <span>Component #{{ $index + 1 }} <small class="text-muted">({{ $componentClass::label() ?? 'Unknown' }})</small></span>
            <button wire:click="removeItem({{ $index }})" class="btn btn-sm btn-outline-danger">Remove</button>
        </div>
        <div class="card-body">
            @foreach ($fields as $field)
            @php
            $name = $field['name'];
            $type = $field['type'] ?? 'text';
            $label = $field['label'] ?? ucfirst($name);
            @endphp

            <div class="mb-3">
                <label class="form-label">{{ $label }}</label>

                @if (in_array($type, ['text', 'textarea']))
                <input type="text" wire:model="items.{{ $index }}.settings.{{ $name }}" class="form-control" />

                @elseif ($type === 'image')
                <div class="d-flex flex-column gap-2">
                    @if (!empty($items[$index]['settings'][$name]))
                    <div class="d-flex justify-content-center">

                        <img src="{{ $items[$index]['settings'][$name] }}" class="img-fluid" style="max-height: 120px;">
                    </div>
                    @endif
                    <button type="button"
                        class="btn btn-outline-secondary btn-sm"
                        wire:click="$dispatch('open-file-picker', { model: '{{ 'items.' . $index . '.settings.' . $name }}' })">
                        Select Image
                    </button>
                </div>

                @elseif ($type === 'repeater')
                @foreach ($items[$index]['settings'][$name] ?? [[]] as $subIndex => $subItem)
                <div class="border rounded p-3 mb-3 bg-light" wire:key="item-{{ $index }}-repeater-{{ $subIndex }}">
                    @foreach ($field['fields'] as $subField)
                    @php
                    $subName = $subField['name'];
                    $subType = $subField['type'] ?? 'text';
                    $subLabel = $subField['label'] ?? ucfirst($subName);
                    @endphp

                    <div class="mb-2">
                        <label class="form-label small">{{ $subLabel }}</label>

                        @if ($subType === 'text')
                        <input type="text"
                            wire:model="items.{{ $index }}.settings.{{ $name }}.{{ $subIndex }}.{{ $subName }}"
                            class="form-control form-control-sm" />

                        @elseif ($subType === 'image')
                        <div class="d-flex flex-column gap-2">
                            @if (!empty($items[$index]['settings'][$name][$subIndex][$subName]))
                            <div class="d-flex justify-content-center">
                                <img src="{{ $items[$index]['settings'][$name][$subIndex][$subName] }}"
                                    class="img-fluid" style="max-height: 100px;">
                            </div>
                            @endif
                            <button type="button"
                                class="btn btn-outline-secondary btn-sm"
                                wire:click="$dispatch('open-file-picker', { model: '{{ 'items.' . $index . '.settings.' . $name . '.' . $subIndex . '.' . $subName }}' })">
                                Select Image
                            </button>
                        </div>
                        @endif
                    </div>
                    @endforeach

                    <button wire:click.prevent="removeRepeater({{ $index }}, '{{ $name }}', {{ $subIndex }})"
                        class="btn btn-sm btn-outline-danger">Remove</button>
                </div>
                @endforeach

                <button wire:click.prevent="addRepeater({{ $index }}, '{{ $name }}')"
                    class="btn btn-sm btn-outline-primary">+ Add Item</button>
                @endif
            </div>
            @endforeach
        </div>
    </div>
    @endforeach

    <div class="mt-4">
        <button wire:click="save" class="btn btn-primary">Save Page</button>
        @if (session()->has('message'))
        <div class="text-success small mt-2">{{ session('message') }}</div>
        @endif
    </div>

    <livewire:admin.components.file-picker-modal />
</div>
