<div
    x-data="desktopSearch($wire)"
    x-on:keydown.escape="close()"
    class="flex-grow">
    <div class="relative">
        <!-- Input + Clear -->
        <div class="group relative z-20 flex h-12 w-full items-center gap-2 overflow-hidden rounded-lg border bg-background pr-2 duration-150">
            <div class="i-carbon-search h-6 w-6 text-text/60"></div>

            <form action="{{ route('shop') }}" class="h-12 w-full" @submit.prevent="$refs.input.blur(); goToShop()">
                <label for="desktopSearchInput" class="sr-only">{{ __('search') }}</label>

                <!-- live two-way bind to Livewire with debounce; Alpine also sees it via entangle -->
                <input
                    x-ref="input"
                    id="desktopSearchInput"
                    type="search"
                    autocomplete="off"
                    placeholder="{{ __('What are you looking for?') }}"
                    x-model.debounce.300ms="query"
                    @focus="onFocus()"
                    class="h-12 w-full bg-transparent outline-none placeholder:transition-transform placeholder:duration-200 group-focus-within:placeholder:-translate-x-2" />
            </form>

            <!-- Clear button -->
            <button
                x-show="query.length"
                @click="clear()"
                type="button"
                class="ml-2 cursor-pointer h-6 w-6 items-center justify-center rounded-lg border bg-muted p-px text-text/60 duration-200 hover:border-primary hover:bg-background"
                aria-label="{{ __('Clear search') }}">
                <span class="i-lucide-x h-4 w-4"></span>
            </button>
        </div>

        <!-- Results dropdown -->
        <div
            x-show="open"
            x-transition
            @click.outside="close()"
            class="absolute left-0 top-16 z-20 w-full space-y-8 rounded-lg bg-muted p-4">
            <!-- Products -->
            @if(false && !empty($products))
            <div class="swiper search-result-slider">
                <div class="swiper-wrapper">
                    @forelse($products as $product)
                    <div class="swiper-slide">
                        <a href="{{ route('product.details', $product->slug) }}"
                            class="flex items-center gap-x-2 rounded-xl border p-2 hover:border-border/50">
                            <img src="{{ $product->brand_img }}" alt="{{ $product->title }}"
                                class="h-20 w-20 rounded-lg object-cover" />
                            <p class="line-clamp-2 text-text/95">{{ $product->title }}

                            </p>
                        </a>
                    </div>
                    @empty
                    <div class="col-span-full text-sm text-text/60">{{ __('No products') }}</div>
                    @endforelse


                </div>
            </div>
            @endif
            @if(!empty($products))
            <div>
                <div class="mb-3 text-sm font-medium text-text/70">{{ __('Products') }}</div>
                <div class="grid grid-cols-2 gap-3 lg:grid-cols-3">
                    @forelse($products as $product)
                    <a href="{{ route('product.details', $product->slug) }}"
                        class="rounded-xl border bg-background p-3 duration-150 hover:border-primary"
                        @click="close()">
                        <div class="flex items-center gap-2 text-sm font-medium line-clamp-2">
                            <img class="w-16 aspect-square rounded" src="{{ $product->brand_img }}" alt="{{ $product->title }}">
                            {{ $product->title }}
                        </div>
                        <div class="flex justify-end mt-1 text-xs text-text/70">
                            {{ $product->display_price }}
                        </div>
                    </a>
                    @empty
                    <div class="col-span-full text-sm text-text/60">{{ __('No products') }}</div>
                    @endforelse
                </div>
            </div>
            @endif

            @if (!empty($productInCategories))
            <div>
                <ul class="space-y-2">
                    @forelse($productInCategories as $cat)
                    <li>
                        <a href="{{ route('shop', ['category' => $cat->slug ?? $cat->id , 'search' => $query]) }}" class="flex items-center gap-2 py-2 duration-200 hover:text-primary">
                            جستجوی
                            {{ $query }}
                            در دسته بندی
                            {{ $cat->name }}
                            <span class="i-ic-outline-arrow-outward"></span>
                        </a>
                    </li>
                    @empty
                    @endforelse

                </ul>
            </div>
            @endif

            <!-- Categories -->
            @if(!empty($categories))
            <div>
                <div class="mb-3 text-sm font-medium text-text/70">{{ __('Categories') }}</div>
                <div class="flex flex-wrap gap-2">
                    @forelse($categories as $cat)
                    <a href="{{ route('shop', ['category' => $cat->slug ?? $cat->id]) }}"
                        class="rounded-2xl border px-3 py-1 text-sm text-text/80 duration-150 hover:bg-background"
                        @click="close()">
                        {{ $cat->name }}
                    </a>
                    @empty
                    <span class="text-sm text-text/60">{{ __('No categories') }}</span>
                    @endforelse
                </div>
            </div>
            @endif

            @if(empty($products) && empty($categories) && strlen($query))
            <div class="text-sm text-text/60">{{ __('No results for') }} “<span x-text="query"></span>”</div>
            @endif
        </div>
    </div>

    <!-- Overlay -->
    <div
        x-show="open"
        x-transition.opacity
        class="relative z-10"
        @click="close()"
        aria-hidden="true">
        <div class="fixed inset-0 bg-black/40"></div>
    </div>
</div>

<script>
    // Alpine component: all behavior lives here; no global functions needed
    function desktopSearch($wire) {
        return {
            // Livewire <-> Alpine shared state
            query: $wire.entangle('query').live, // keeps in sync with PHP
            open: $wire.entangle('showDropdown').live, // dropdown visibility

            onFocus() {
                this.open = this.query?.length > 0;
            },
            clear() {
                this.query = '';
                this.$nextTick(() => this.$refs.input.focus());
                this.open = false;
            },
            close() {
                this.open = false;
            },
            goToShop() {
                // simple redirect honoring route('shop', ['q' => query])
                const url = new URL(@json(route('shop')), window.location.origin);
                if (this.query?.length) url.searchParams.set('q', this.query);
                window.location.href = url.toString();
            },
        }
    }
</script>
