<div class="space-y-6">

    @if($errors->any())
    <div class="p-5">
        <x-blesser.ui.alert type="error">
            <ul>
                @foreach($errors->all() as $error)
                <li>{{ $error }}</li>
                @endforeach
            </ul>
        </x-blesser.ui.alert>
    </div>
    @endif

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <x-blesser.ui.form.input name="customer_name" wire:model.defer="customer_name" placeholder="نام مشتری" />
        <x-blesser.ui.form.input name="company_name" wire:model.defer="company_name" placeholder="نام شرکت" />
        <x-blesser.ui.form.input name="email" wire:model.defer="email" placeholder="ایمیل" type="email" />
        <x-blesser.ui.form.input name="phone" wire:model.defer="phone" placeholder="شماره تماس" />
        <x-blesser.ui.form.input name="city" wire:model.defer="city" placeholder="شهر" />
        <x-blesser.ui.form.input name="postal_code" wire:model.defer="postal_code" placeholder="کد پستی" />
        <x-blesser.ui.form.textarea name="address" wire:model.defer="address" placeholder="آدرس کامل" rows="3" />
        <x-blesser.ui.form.textarea name="notes" wire:model.defer="notes" placeholder="یادداشت" rows="3" />
    </div>

    <hr class="my-6 border-gray-300" />

    <div>
        <h3 class="text-lg font-semibold mb-4">{{ __('Products / Items') }}</h3>

        @foreach($items as $i => $item)
        <div class="grid grid-cols-12 gap-2 items-center mb-2 p-3 border rounded-lg">
            <div class="col-span-12 md:col-span-12 lg:col-span-4">
                <x-blesser.ui.form.input name="items.{{ $i }}.name" wire:model.defer="items.{{ $i }}.name"
                    placeholder="نام کالا" />
            </div>
            <div class="col-span-12 md:col-span-3 lg:col-span-2">
                <x-blesser.ui.form.input name="items.{{ $i }}.qty" wire:model.defer="items.{{ $i }}.qty"
                    placeholder="تعداد" type="number" />
            </div>
            <div class="col-span-12 md:col-span-3 lg:col-span-2">
                <x-blesser.ui.form.input name="items.{{ $i }}.unit" wire:model.defer="items.{{ $i }}.unit"
                    placeholder="واحد" />
            </div>
            <div class="col-span-12 md:col-span-4 lg:col-span-3">
                <x-blesser.ui.form.input name="items.{{ $i }}.external_url"
                    wire:model.defer="items.{{ $i }}.external_url" placeholder="لینک محصول (اختیاری)" />
            </div>
            <div class="col-span-12 md:col-span-2 lg:col-span-1 flex justify-end">
                <button type="button" wire:click.prevent="removeItem({{ $i }})"
                    class="bg-red-600 hover:bg-red-800 rounded-lg cursor-pointer  px-4 py-2">
                    {{ __('delete') }}
                </button>
            </div>
            <div class="col-span-12">
                <x-blesser.ui.form.textarea name="items.{{ $i }}.description" wire:model.defer="items.{{ $i }}.description" placeholder="توضیحات (اختیاری)" rows="2" />
            </div>
        </div>
        @endforeach

        <button type="button" wire:click.prevent="addItem"
            class="mt-3 px-4 py-2 bg-primary text-white rounded-lg hover:bg-primary/90">
            {{ __('Add a new item') }}
        </button>
    </div>

    <div class="flex justify-end">
        <button wire:click="save" type="button"
            class="cursor-pointer rounded-lg bg-emerald-500 px-4 py-2 text-center text-white duration-200 hover:bg-emerald-500/80 disabled:bg-success/40 disabled:text-text/60 disabled:hover:bg-success/45 dark:bg-emerald-600 dark:hover:bg-emerald-600/80">
            {{ __('submit pre invoice request') }}
        </button>
    </div>
</div>
