@extends('layouts.syndron.app')

@section('content')

@php
$columns = [
    'label',
    'type',
    'name',
    'default value',
    'is required',
    'is filterable',
    'filter type',
    'is price effective',
    'action',
];
@endphp

<x-syndron.breadcrumb title="{{ __('Attributes') }}">
    <x-syndron.breadcrumb-item url="{{ route('admin.categories.index') }}">
        {{ __(key: 'Categories') }}

    </x-syndron.breadcrumb-item>
    <x-syndron.breadcrumb-item active>
        {{ __(key: 'Attributes') }}
    </x-syndron.breadcrumb-item>
</x-syndron.breadcrumb>


<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div class="">

        </div>
        <div>
            <a href="{{ route('admin.category.attribute.create' , $category->id) }}" class="btn btn-success">
                {{ __('create a new attribute') }}
            </a>
            <a href="{{ route('admin.category.attribute.create' , ['category' => $category->id , 'is_variant' => true]) }}" class="btn btn-info">
                {{ __('create a new variant') }}
            </a>
        </div>
    </div>
    <div class="card-body">
        <x-syndron.ui.table :columns="$columns">
            @foreach ($attributes as $attribute )
            <tr>
                <td>{{ $attribute->label  }}</td>
                <td>{{ $attribute->type  }}</td>
                <td>{{ $attribute->name  }}</td>
                <td>{{ $attribute->default_value  }}</td>
                <td>{{ $attribute->is_required  }}</td>
                <td>{{ $attribute->is_filterable  }}</td>
                <td>{{ $attribute->filter_type  }}</td>
                <td>{{ $attribute->is_price_effective  }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('category.attribute.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.category.attribute.edit', [$category->id, $attribute->id]) }}">
                                    {{__('Edit')}}
                                </a>
                            </li>
                            @endcan

                            @can('category.attribute.item.view')
                            @if ($attribute->type == \App\Enums\CategoryAttributeTypeEnum::Select->value)
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.attribute.item.index' , $attribute->id) }}">
                                    {{ __('items') }}
                                </a>
                            </li>
                            @endif
                            @endcan

                            @can('category.attribute.delete')
                            <li>
                                <form action="{{ route('admin.category.attribute.destroy', ['category' => $category->id,'attribute'=> $attribute->id]) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this attribute?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

{{ $attributes->links() }}
@endsection
