@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-body">
        <x-syndron.ui.table :columns="['ID','Date','Delivery Time ID','Taken','Actions']">
            @foreach($deliveryDayCapacities as $capacity)
            <tr>
                <td>{{ $capacity->id }}</td>
                <td>{{ $capacity->date }}</td>
                <td>{{ $capacity->delivery_time_id }}</td>
                <td>{{ $capacity->taken }}</td>
                <td>
                    @can('delivery.day-capacity.view')
                    <a href="{{ route('admin.delivery.day-capacities.show', $capacity) }}" class="btn btn-info btn-sm">{{ __('View') }}</a>
                    @endcan

                    @can('delivery.day-capacity.edit')
                    <a href="{{ route('admin.delivery.day-capacities.edit', $capacity) }}" class="btn btn-warning btn-sm">{{ __('Edit') }}</a>
                    @endcan

                    @can('delivery.day-capacity.delete')
                    <form action="{{ route('admin.delivery.day-capacities.destroy', $capacity) }}" method="POST" style="display:inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('<?php echo __('Are you sure?'); ?>')">{{ __('Delete') }}</button>
                    </form>
                    @endcan
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
