@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>
                {{ __('Delivery Provider') }}
            </h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.delivery.providers.create') }}">
                {{ __('Create a new Delivery Provider') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['name' , 'code' , 'contact phone','contact email','notes','action']">
            @foreach ($providers as $provider )
            <tr>
                <td>{{ $provider->name  }}</td>
                <td>{{ $provider->code  }}</td>
                <td>{{ $provider->contact_phone  }}</td>
                <td>{{ $provider->contact_email  }}</td>
                <td>{{ $provider->notes  }}</td>

                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('delivery.provider.edit')
                            <li><a class="dropdown-item" href="{{ route('admin.delivery.providers.edit' , $provider->id) }}">{{ __('Edit') }}</a></li>
                            @endcan

                            @can('delivery.provider.delete')
                            <li>
                                <form action="{{ route('admin.delivery.providers.destroy' , $provider->id) }}" method="POST" onsubmit="return confirm('<?php echo __('Are you sure you want to delete this provider?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>
@endsection
