@extends('layouts.syndron.app')

@section('content')

<div class="card">
    <div class="card-header d-flex justify-content-between">
        <div>
            <h4>{{ __('Questions') }}</h4>
        </div>
        <div>
            <a class="btn btn-success" href="{{ route('admin.faq.questions.create') }}">
                {{ __('Create a new question') }}
            </a>
        </div>
    </div>

    <div class="card-body">
        <x-syndron.ui.table :columns="['title', 'category', 'status', 'actions']">
            @foreach ($questions as $question)
            <tr>
                <td>{{ $question->title }}</td>
                <td>{{ \Artemis\Faq\Models\Category::find($question->category_id)->name }}</td>
                <td>{{ $question->status }}</td>
                <td>
                    <div class="dropdown">
                        <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('Actions') }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            @can('faq.question.view')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.faq.questions.show', $question->id) }}">{{ __('show') }}</a>
                            </li>
                            @endcan

                            @can('faq.question.edit')
                            <li>
                                <a class="dropdown-item" href="{{ route('admin.faq.questions.edit', $question->id) }}">{{ __('Edit') }}</a>
                            </li>
                            @endcan

                            @can('faq.question.delete')
                            <li>
                                <form action="{{ route('admin.faq.questions.destroy', $question->id) }}" method="POST" onsubmit="return confirm('<?php echo  __('Are you sure you want to delete this question?') ?>');">
                                    @csrf
                                    @method('DELETE')
                                    <button class="dropdown-item text-danger" type="submit">{{ __('Delete') }}</button>
                                </form>
                            </li>
                            @endcan
                        </ul>
                    </div>
                </td>
            </tr>
            @endforeach
        </x-syndron.ui.table>
    </div>
</div>

@endsection
