@extends('layouts.syndron.app')

@section('content')

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="h4">{{ __('Modules Management') }}</h2>
    </div>

    @if(session('status'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('status') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="table-responsive">
        <table class="table table-bordered align-middle">
            <thead class="table-light">
                <tr>
                    <th scope="col">{{ __('label') }}</th>
                    <th scope="col">{{ __('Name') }}</th>
                    <th scope="col">{{ __('Status') }}</th>
                    <th scope="col" class="text-center" style="width: 120px;">{{ __('Action') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach(module() as $key => $module)
                <tr>
                    <td> {{ __($module->label) }} </td>
                    <td><code>{{ $key }}</code></td>
                    <td>
                        @if ($module->isActive())
                        <span class="badge bg-success">{{ __('Enabled') }}</span>
                        @else
                        <span class="badge bg-danger">{{ __('Disabled') }}</span>
                        @endif
                    </td>
                    <td class="text-center">
                        <div method="" action="">
                            <button type="button" class="btn btn-sm btn-secondary {{ $module->isActive() ? '-btn-danger' : '-btn-success' }}">
                                <!-- {{ $module->isActive() ? __('Disable') : __('Enable') }} -->
                                {{ __('Access Restricted') }}
                            </button>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
